# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

WPFort Security Suite is a WordPress security plugin that provides comprehensive protection through malware scanning, firewall protection, backup management, and vulnerability detection. The plugin offers a REST API for external integrations and automated security monitoring.

## Architecture

### Core Structure
- **Main Plugin File**: `wpfortai-security.php` - Plugin initialization and WordPress hooks
- **API Endpoints**: `endpoints/` - REST API endpoints following `/wp-json/wpsec/v1/` namespace
- **Core Logic**: `includes/` - Main functionality modules
- **Scanning Engines**: `includes/engines/` - Different malware detection algorithms
- **Admin Interface**: `admin/` - WordPress admin dashboard integration

### Key Components

#### Scanning System
The malware scanning system uses multiple detection engines working in parallel:
- **Signature Engine** (`includes/engines/signature.php`) - Known malware signatures
- **Pattern Engine** (`includes/engines/pattern.php`) - Suspicious code patterns  
- **Heuristic Engine** (`includes/engines/heuristic.php`) - Behavioral analysis
- **Anomaly Engine** (`includes/engines/anomaly.php`) - Unusual file characteristics
- **Advanced Engines** - Database, htaccess, login, and potential threat detection

#### API Architecture
REST endpoints are organized by functionality:
- `endpoint-scan.php` - Malware scanning operations
- `endpoint-firewall.php` - Firewall management
- `endpoint-backup.php` - Backup operations
- `endpoint-vulnerabilities.php` - Vulnerability checking
- `endpoint-health.php` - System health monitoring

#### Core Modules
- `includes/scan.php` - Main scanning orchestration
- `includes/advanced-firewall.php` - Firewall implementation
- `includes/backup/` - Backup system with multiple storage providers
- `includes/webhooks.php` - External webhook notifications

## Development

### No Build System
This is a PHP WordPress plugin with no build, compilation, or dependency management system. Files are used directly as written.

### Testing
No formal test framework is configured. Testing appears to be done through:
- Plugin activation in WordPress development environment
- API endpoint testing via REST calls
- Manual testing through admin interface

### Code Standards
- PHP code follows WordPress coding standards
- API responses use consistent JSON structure
- Error handling follows WordPress REST API patterns
- Security implemented through API key authentication

## Key Features

### Malware Scanning
- Multi-engine detection system
- Background scan processing with resume capability
- Quarantine system for infected files
- Scan result caching and history

### Firewall Protection
- Real-time threat blocking
- IP whitelisting/blacklisting
- Attack logging and analytics
- Geographic threat analysis

### Backup Management
- Multiple storage providers (Backblaze integration visible)
- Scheduled backup operations
- Backup verification and restoration

### API Integration
- Comprehensive REST API for external tools
- Webhook support for notifications
- Rate limiting and security controls
- Public ping endpoint for monitoring

## Security Considerations

This codebase handles sensitive security operations and should be treated with appropriate caution. The plugin manages:
- File system scanning and quarantine
- Firewall rules and IP blocking
- Backup operations and restoration
- WordPress core file integrity

## Development Notes

- Plugin uses WordPress hooks and filters extensively
- Scan operations are designed to run in background with resume capability
- Heavy use of WordPress options API for configuration storage
- Logging system integrated throughout for debugging and monitoring