# WPFort Security Plugin API Documentation

=== WPFort Security Suite ===
Tested up to: 6.4.2
License: GPLv2 or later
Stable Tag: 1.3.1

WPFort Security Plugin provides a comprehensive REST API for managing security scans, firewall settings, updates, and backups. All endpoints are accessible under the `/wp-json/wpsec/v1/` namespace.

## Authentication

Most API endpoints require authentication using an API key. Include the API key in the request headers:

```http
x-api-key: sadasda78as78sda78sda78sfa687fajk
```

**Note:** The `/ping` endpoint is the only endpoint that does not require authentication.

## Endpoints

### Malware Scanning

#### Start a New Scan
```http
POST /wp-json/wpsec/v1/scan
```

Initiates a new security scan of the WordPress installation.

**Response**
```json
{
    "status": "success",
    "message": "Scan started and running in the background",
    "scan_id": "wpsec_67be245e3e99a4.59168786",
    "started_at": "2025-02-25 20:13:18",
    "estimated_duration": "30.68 seconds",
    "check_status_endpoint": "/wp-json/wpsec/v1/scan-status/wpsec_67be245e3e99a4.59168786",
    "results_endpoint": "/wp-json/wpsec/v1/results"
}
```

#### Check Scan Status
```http
GET /wp-json/wpsec/v1/scan-status/{scan_id}
```

Get the current status of a running or completed scan.

**Response**
```json
{
    "scan_id": "wpsec_67be245e3e99a4.59168786",
    "status": "running",
    "started_at": "2025-02-25 20:13:18",
    "progress": 45,
    "files_scanned": 123,
    "total_files": 256,
    "results_endpoint": "/wp-json/wpsec/v1/results"
}
```

For completed scans, additional fields are included:
```json
{
    "completed_at": "2025-02-25 20:13:26",
    "duration": 8
}
```

#### Get Scan Results
```http
GET /wp-json/wpsec/v1/results
```

or

```http
GET /wp-json/wpsec/v1/scan/{id}/results
```

Retrieve results from a completed scan.

**Response**
```json
{
    "status": "success",
    "scan_summary": {
        "scan_id": "wpsec_67be245e3e99a4",
        "started_at": "2025-02-25 20:13:18",
        "completed_at": "2025-02-25 20:17:33",
        "duration": "4.25 minutes",
        "total_files_scanned": 2547,
        "files_skipped": 12,
        "errors": 2
    },
    "threat_summary": {
        "total_threats": 3,
        "critical": 1,
        "high": 1,
        "medium": 1,
        "low": 0
    },
    "infected_files": [
        {
            "file_path": "wp-content/uploads/suspicious.php",
            "file_size": 24680,
            "modified_at": "2025-02-24 15:45:22",
            "detections": [
                {
                    "type": "signature",
                    "name": "PHP.Backdoor.Generic",
                    "severity": "critical",
                    "confidence": 100,
                    "threat_score": 9.5,
                    "context": {
                        "line_number": 45,
                        "snippet": "base64_decode('...')",
                        "signature_id": "SIG_PHP_BACKDOOR_001"
                    }
                },
                {
                    "type": "pattern",
                    "name": "Suspicious Function Usage",
                    "severity": "high",
                    "confidence": 85,
                    "threat_score": 7.8,
                    "context": {
                        "line_number": 46,
                        "snippet": "eval($decoded)",
                        "pattern_id": "PAT_EVAL_BASE64"
                    }
                }
            ],
            "aggregate_score": 9.5,
            "recommended_action": "quarantine",
            "quarantine_token": "qt_67be245e3e99a4_001"
        }
    ],
    "system_stats": {
        "memory_peak": "312MB",
        "cpu_usage_avg": "45%",
        "io_reads": 15678,
        "io_writes": 234
    }
}
```

#### Get Recent Scans
```http
GET /wp-json/wpsec/v1/scan/history
```

Retrieve a list of recent scans and their basic results.

**Parameters**
| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| limit | integer | No | Maximum number of scans to return (default: 10, max: 50) |
| status | string | No | Filter by status: all, completed, failed (default: all) |

**Response**
```json
{
    "status": "success",
    "scans": [
        {
            "scan_id": "wpsec_67be245e3e99a4",
            "type": "full",
            "status": "completed",
            "started_at": "2025-02-25 20:13:18",
            "completed_at": "2025-02-25 20:17:33",
            "summary": {
                "total_files": 2547,
                "threats_found": 3,
                "highest_severity": "critical"
            }
        }
    ],
    "pagination": {
        "total": 45,
        "page": 1,
        "per_page": 10
    }
}
```

### Firewall Management

#### Get Firewall Status
```http
GET /wp-json/wpsec/v1/firewall/status
```

Get the current status of the firewall.

**Response**
```json
{
    "status": "success",
    "is_active": true,
    "rules_count": 15,
    "last_attack": "2025-02-25 19:45:12",
    "blocked_count": 127
}
```

#### Toggle Firewall
```http
POST /wp-json/wpsec/v1/firewall/toggle
```

Enable or disable the firewall.

**Request Body**
```json
{
    "active": true
}
```

**Response**
```json
{
    "status": "success",
    "message": "Firewall has been activated",
    "is_active": true
}
```

#### Get Firewall Logs
```http
GET /wp-json/wpsec/v1/firewall/logs
```

Retrieve firewall activity logs and statistics for a specified time period.

**Parameters**

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| period | string | No | Number of days to retrieve logs for. Valid values: `7`, `14`, `30`. Defaults to `7` if not specified or invalid. |

**Example Request**
```http
GET /wp-json/wpsec/v1/firewall/logs?period=30
```

**Response**
```json
{
    "success": true,
    "data": {
        "summary": {
            "period_days": "30",
            "total_blocks": 156,
            "critical_attacks": 10
        },
        "trends": {
            "attacks_by_day": [
                {
                    "date": "2025-01-27",
                    "total": 12,
                    "critical": 1
                }
                // ... more days
            ]
        },
        "top_threats": {
            "ips": [
                {
                    "ip": "192.168.1.1",
                    "country": "France",
                    "count": 45
                }
            ],
            "countries": [
                {
                    "name": "France",
                    "count": 78
                },
                {
                    "name": "United States",
                    "count": 65
                },
                {
                    "name": "China",
                    "count": 42
                },
                {
                    "name": "Russia",
                    "count": 38
                },
                {
                    "name": "Germany",
                    "count": 29
                },
                {
                    "name": "Brazil",
                    "count": 24
                },
                {
                    "name": "India",
                    "count": 19
                },
                {
                    "name": "Canada",
                    "count": 17
                },
                {
                    "name": "United Kingdom",
                    "count": 15
                },
                {
                    "name": "Australia",
                    "count": 12
                }
            ],
            "rules": {
                "sql_injection": {
                    "count": 34,
                    "severity": "high"
                },
                "file_upload": {
                    "count": 28,
                    "severity": "high"
                },
                "xss": {
                    "count": 22,
                    "severity": "medium"
                }
            }
        },
        "recent_blocks": [
            {
                "timestamp": "2025-02-25 20:15:33",
                "ip": "192.168.1.1",
                "country": "France",
                "request_uri": "/wp-admin/admin-ajax.php",
                "rules": {
                    "sql_injection": {
                        "rule": "sql_injection",
                        "matched": "UNION SELECT",
                        "score": 5
                    }
                },
                "is_critical": true,
                "risk_score": 10
            }
        ]
    }
}
```

#### Manage IP Whitelist
```http
GET /wp-json/wpsec/v1/firewall/whitelist
POST /wp-json/wpsec/v1/firewall/whitelist
DELETE /wp-json/wpsec/v1/firewall/whitelist
```

Manage whitelisted IP addresses.

**POST Request Body**
```json
{
    "ip": "192.168.1.100"
}
```

**Response**
```json
{
    "status": "success",
    "message": "IP added to whitelist",
    "whitelist": ["192.168.1.100"]
}
```

### Backup Management

#### Start Backup
```http
POST /wp-json/wpsec/v1/backup/start
```

Start a new backup process.

**Parameters**
```json
{
    "type": "daily"  // Backup type (daily, weekly, monthly)
}
```

#### Get Backup Status
```http
GET /wp-json/wpsec/v1/backup/status/{backup_id}
```

Get the current status of a backup operation.

**Response**
```json
{
    "backup_id": "wpsec_backup_67be245e3e99a4",
    "status": "in_progress",
    "started_at": "2025-02-25 20:13:18",
    "progress": 45,
    "current_stage": "uploading",
    "stage_progress": 67,
    "total_size": "1.2GB",
    "uploaded_size": "820MB"
}
```

#### List Backups
```http
GET /wp-json/wpsec/v1/backup/list
```

Retrieve a list of all available backups.

**Response**
```json
{
    "status": "success",
    "backups": [
        {
            "id": "wpsec_backup_67be245e3e99a4",
            "type": "full",
            "created_at": "2025-02-25 20:13:18",
            "size": "1.2GB",
            "status": "completed",
            "destination": "backblaze",
            "download_url": "https://..."
        }
    ],
    "storage_usage": {
        "total": "5.4GB",
        "available": "94.6GB"
    }
}
```

### WordPress Core Check

#### Run Core Check
```http
POST /wp-json/wpsec/v1/core-check
```

Initiates a WordPress core files integrity check.

**Response**
```json
{
    "status": "success",
    "message": "Core check started",
    "check_id": "wpsec_core_67be245e3e99a4",
    "started_at": "2025-02-25 20:13:18",
    "check_status_endpoint": "https://your-site.com/wp-json/wpsec/v1/core/status/wpsec_core_67be245e3e99a4"
}
```

#### Get Core Check Status
```http
GET /wp-json/wpsec/v1/core/status/{check_id}
```

Get the current status of a core check operation.

**Response**
```json
{
    "check_id": "wpsec_core_67be245e3e99a4",
    "status": "completed",
    "started_at": "2025-02-25 20:13:18",
    "completed_at": "2025-02-25 20:13:26",
    "results": {
        "total_files": 1547,
        "modified_files": 3,
        "missing_files": 1,
        "added_files": 0,
        "issues": [
            {
                "file": "wp-includes/version.php",
                "type": "modified",
                "severity": "high",
                "details": "File hash mismatch"
            }
        ]
    }
}
```

### Malware Quarantine

#### List Quarantined Files
```http
GET /wp-json/wpsec/v1/quarantine/list
```

Get a list of all files in quarantine.

**Response**
```json
{
    "status": "success",
    "quarantined_files": [
        {
            "original_path": "wp-content/uploads/suspicious.php",
            "quarantined_at": "2025-02-25 20:13:18",
            "threat_details": {
                "type": "malware",
                "severity": "critical",
                "detection_method": "signature"
            },
            "file_hash": "a1b2c3d4e5f6..."
        }
    ]
}
```

#### Restore from Quarantine
```http
POST /wp-json/wpsec/v1/quarantine/restore
```

Restore a file from quarantine.

**Request Body**
```json
{
    "file_hash": "a1b2c3d4e5f6..."
}
```

**Response**
```json
{
    "status": "success",
    "message": "File restored successfully",
    "restored_to": "wp-content/uploads/suspicious.php"
}
```

### Updates & Vulnerabilities

#### Check for Vulnerabilities
```http
GET /wp-json/wpsec/v1/vulnerabilities
```

Check for known vulnerabilities in installed plugins and themes.

**Response**
```json
{
    "status": "success",
    "vulnerabilities": [
        {
            "type": "plugin",
            "name": "Example Plugin",
            "version": "1.2.3",
            "vulnerabilities": [
                {
                    "title": "SQL Injection Vulnerability",
                    "severity": "high",
                    "fixed_in": "1.2.4"
                }
            ]
        }
    ]
}
```

#### Update Specific Items
```http
POST /wp-json/wpsec/v1/update-items
```

Update specific plugins or themes.

**Request Body**
```json
{
    "type": "plugin",
    "items": [
        {"slug": "example-plugin"}
    ]
}
```

**Response**
```json
{
    "total_items": 1,
    "successful_updates": 1,
    "results": [
        {
            "slug": "example-plugin",
            "success": true,
            "name": "Example Plugin",
            "old_version": "1.2.3",
            "new_version": "1.2.4"
        }
    ]
}
```

#### Update All
```http
POST /wp-json/wpsec/v1/update-all
```

Update WordPress core, all plugins, and all themes.

**Response**
```json
{
    "status": "success",
    "message": "All updates completed",
    "results": {
        "core": {
            "success": true,
            "message": "Core successfully updated"
        },
        "plugins": [
            {
                "plugin": "example-plugin",
                "success": true,
                "message": "Successfully updated"
            }
        ],
        "themes": []
    }
}
```

### Health Check Endpoints

#### Health Check (Authenticated)
```http
GET /wp-json/wpsec/v1/health
```

Get comprehensive health information about the plugin and WordPress installation. Requires API key authentication.

**Response**
```json
{
    "success": true,
    "data": {
        "plugin_version": "1.3.1",
        "plugin_active": true,
        "wordpress_version": "6.7.2",
        "php_version": "8.2.4",
        "timestamp": "2025-03-06 18:25:33",
        "firewall_status": {
            "active": true,
            "rules_count": 5,
            "total_blocks": 156,
            "critical_attacks": 10
        },
        "database_connected": true,
        "logs_writable": true
    }
}
```

#### Ping (Public, No Authentication)
```http
GET /wp-json/wpsec/v1/ping
```

Simple endpoint to verify the plugin is installed and active. Does not require authentication.

**Response**
```json
{
    "success": true,
    "data": {
        "plugin_active": true,
        "plugin_version": "1.3.1"
    }
}
```

## Error Responses

All endpoints will return appropriate HTTP status codes:

- `200`: Success
- `400`: Bad Request (invalid parameters)
- `401`: Unauthorized (invalid or missing API key)
- `403`: Forbidden
- `404`: Not Found
- `500`: Internal Server Error

Error Response Format:
```json
{
    "code": "error_code",
    "message": "Human readable error message",
    "data": {
        "status": 400
    }
}
```

## Rate Limiting

The API implements standard WordPress rate limiting. Please ensure reasonable intervals between requests to avoid being temporarily blocked.

## Best Practices

1. Always check scan status before retrieving results
2. Implement exponential backoff for polling scan status
3. Handle errors gracefully and retry failed requests
4. Cache API responses when appropriate
5. Use the update-all endpoint during off-peak hours
