<?php
defined('ABSPATH') || exit;

function wpsec_site_info_endpoint($request) {
    global $wp_version;
    
    // Get PHP version
    $php_version = phpversion();
    
    // Get WordPress version
    $wp_version_info = $wp_version;
    
    // Get site URL and domain
    $site_url = get_site_url();
    $domain = wp_parse_url($site_url, PHP_URL_HOST);
    
    // Get theme information
    $active_theme = wp_get_theme();
    $themes = wp_get_themes();
    $theme_count = count($themes);
    
    // Get plugin information
    if (!function_exists('get_plugins')) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    $all_plugins = get_plugins();
    $active_plugins = get_option('active_plugins');
    $plugin_count = count($all_plugins);
    $active_plugin_count = count($active_plugins);
    
    // Get server information
    $server_software = $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown';
    
    // Get database information
    global $wpdb;
    $db_version = $wpdb->db_version();
    
    // Get memory information
    $memory_limit = ini_get('memory_limit');
    $wp_memory_limit = WP_MEMORY_LIMIT;
    
    // Get SSL status
    $is_ssl = is_ssl();
    
    // Get the site authorization code if it exists
    $site_auth_code = get_option('wpsec_site_auth_code', '');   

    // Compile response
    $response = [
        'wordpress' => [
            'version' => $wp_version_info,
            'site_url' => $site_url,
            'domain' => $domain,
            'is_multisite' => is_multisite(),
            'is_ssl' => $is_ssl,
            'auth_code' => $site_auth_code, // Add the auth code to the wordpress section
        ],
        'themes' => [
            'active_theme' => [
                'name' => $active_theme->get('Name'),
                'version' => $active_theme->get('Version'),
            ],
            'total_count' => $theme_count,
        ],
        'plugins' => [
            'total_count' => $plugin_count,
            'active_count' => $active_plugin_count,
        ],
        'server' => [
            'php_version' => $php_version,
            'server_software' => $server_software,
            'database_version' => $db_version,
            'memory_limit' => $memory_limit,
            'wp_memory_limit' => $wp_memory_limit,
        ],
        'timestamp' => current_time('mysql'),
    ];
    
    return rest_ensure_response($response);
}
