<?php
/**
 * WPFort Security - Activation functions
 *
 * Handles activation tasks for the plugin
 */

defined('ABSPATH') || exit;

/**
 * Run activation tasks
 */
function wpsec_activate_plugin() {
    // Create necessary database tables
    wpsec_create_database_tables();
    
    // Set default options
    wpsec_set_default_options();
    
    // Log activation
    wpsec_debug_log('✅ WPFort Security: Plugin activated', 'info');
}

/**
 * Create necessary database tables on activation
 */
function wpsec_create_database_tables() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    
    // Create file hash cache table
    $file_hash_table = $wpdb->prefix . 'wpsec_file_hash_cache';
    
    // Check if table exists
    if ($wpdb->get_var("SHOW TABLES LIKE '$file_hash_table'") != $file_hash_table) {
        $sql = "CREATE TABLE $file_hash_table (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            file_path varchar(512) NOT NULL,
            file_hash varchar(32) NOT NULL,
            file_size bigint(20) NOT NULL,
            last_modified bigint(20) NOT NULL,
            last_scanned bigint(20) NOT NULL,
            PRIMARY KEY  (id),
            UNIQUE KEY file_path (file_path),
            KEY file_hash (file_hash),
            KEY last_modified (last_modified),
            KEY last_scanned (last_scanned)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
        
        wpsec_debug_log('✅ WPFort: File hash cache table created', 'info');
    }
}

/**
 * Set default options on activation
 */
function wpsec_set_default_options() {
    // Set default scan batch size to 10,000
    if (!get_option('wpsec_scan_batch_size')) {
        update_option('wpsec_scan_batch_size', 10000);
    }
    
    // Set default scan progress update frequency to 500
    if (!get_option('wpsec_scan_progress_update_frequency')) {
        update_option('wpsec_scan_progress_update_frequency', 500);
    }
    
    // Set default scan checkpoint frequency
    if (!get_option('wpsec_scan_checkpoint_frequency')) {
        update_option('wpsec_scan_checkpoint_frequency', 10000);
    }
}
