<?php
defined('ABSPATH') || exit;

class WPSEC_Plugin {
    private static $instance = null;

    private function __construct() {
        // Initialize plugin components
        $this->init_hooks();
    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function init_hooks() {
        // Add menu items
        add_action('admin_menu', array($this, 'add_admin_menu'));
        
        // Register settings
        add_action('admin_init', array($this, 'register_settings'));
    }

    public function add_admin_menu() {
        add_menu_page(
            'WPFort Security', 
            'WPFort Security',
            'manage_options',
            'wpsec-dashboard',
            array($this, 'render_dashboard'),
            'dashicons-shield',
            100
        );
    }

    public function register_settings() {
        // No longer registering firewall/whitelist settings as they're managed via API
        // We now use wpsec_site_auth_code which is managed directly via the dashboard
    }

    public function render_dashboard() {
        if (!current_user_can('manage_options')) {
            wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'wpfortai-security'));
        }
        
        include_once plugin_dir_path(dirname(__FILE__)) . 'admin/dashboard.php';
    }
}
