<?php
defined('ABSPATH') || exit;

class WPSEC_Upgrader_Skin extends WP_Upgrader_Skin {
    public $messages = array();
    
    public function header() {}
    public function footer() {}
    
    public function feedback($string, ...$args) {
        if ( empty($string) ) {
            return;
        }
        
        if ( is_array($args) && count($args) > 0 ) {
            $string = vsprintf($string, $args);
        }
        
        $this->messages[] = $string;
    }
    
    public function error($errors) {
        if ( is_string($errors) ) {
            $this->messages[] = $errors;
            return;
        }
        
        if ( is_wp_error($errors) && $errors->has_errors() ) {
            foreach ( $errors->get_error_messages() as $message ) {
                if ( $errors->get_error_data() && is_string( $errors->get_error_data() ) ) {
                    $this->messages[] = $message . ' ' . esc_html( wp_strip_all_tags( $errors->get_error_data() ) );
                } else {
                    $this->messages[] = $message;
                }
            }
        }
    }
    
    public function get_messages() {
        return $this->messages;
    }
}
