<?php
defined('ABSPATH') || exit;

class WPSEC_Firewall_Installer {
    public static function install() {
        global $wpdb;
        
        $table_name = $wpdb->prefix . 'wpsec_firewall_logs';
        $charset_collate = $wpdb->get_charset_collate();
        
        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            ip_address varchar(45) NOT NULL,
            country_name varchar(100) DEFAULT NULL,
            timestamp datetime NOT NULL,
            request_uri text NOT NULL,
            user_agent text,
            rules_triggered text NOT NULL,
            risk_score int(11) NOT NULL,
            is_critical tinyint(1) NOT NULL DEFAULT 0,
            PRIMARY KEY  (id),
            KEY ip_address (ip_address),
            KEY timestamp (timestamp),
            KEY is_critical (is_critical)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
        
        // Set default options
        add_option('wpsec_firewall_active', false);
        
        // Default whitelisted IPs - include WPFort backend server
        $default_whitelisted_ips = [
            '62.171.130.143' // WPFort backend server - always allow
        ];
        add_option('wpsec_whitelisted_ips', $default_whitelisted_ips);
    }
}
