<?php
/**
 * WPFort Security Plugin - Whitelist System Wrapper
 *
 * This file provides backward compatibility with existing code that depends on
 * the whitelist.php module, while consolidating the actual functionality into
 * the file-whitelist.php module for better maintainability.
 */

defined('ABSPATH') || exit;

// Include the main, consolidated whitelist system
require_once dirname(__FILE__) . '/file-whitelist.php';

/**
 * Legacy compatibility layer - forward calls to file-whitelist.php
 */

// Forward the advanced definitions whitelist check
if (!function_exists('wpsec_check_advanced_whitelist')) {
    function wpsec_check_advanced_whitelist($file_path, $content = null) {
        return wpsec_check_advanced_definitions_whitelist($file_path, $content);
    }
}

// Forward the unified whitelist check
if (!function_exists('wpsec_is_whitelisted')) {
    function wpsec_is_whitelisted($file_path, $content = null) {
        return wpsec_is_file_whitelisted($file_path, true, $content);
    }
}
